;;  Programm:      ACM-UMFASSUNG.LSP
;;  Befehlsaufruf: ACM-UMFASSUNG
;;  Funktion:      Auswahlsatz 2- oder 3-dimensional umfassen
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         18.03.2024
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-umfassung ( / pms93 pms31 pms94 psm01 psm02 psm03 psm04 psm05 psm06 psm07 psm08 psm09 psm10 psm11 psm12 psm13 psm14 psm15)
    (defun psm01 (pms01 pms02 / pms05 pms06 pms07 pms08)
      (setq pms05 (list (car pms01) (cadr pms01) (caddr pms01)))
      (setq pms06 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms07 (list (car pms02) (cadr pms02) (caddr pms01)))
      (setq pms08 (list (car pms01) (cadr pms01) (caddr pms02)))
        (if (= kwlbhwotmru9mkerdpep "0")
          (prompt
            (strcat
              "\nAusdehnung X = "
              (rtos (distance pms05 pms06))
              ", Ausdehnung Y = "
              (rtos (distance pms06 pms07))
              " "
            )
          )
          (prompt
            (strcat
              "\nAusdehnung X = "
              (rtos (distance pms05 pms06))
              ", Ausdehnung Y = "
              (rtos (distance pms06 pms07))
              ", Ausdehnung Z = "
              (rtos (distance pms05 pms08))
              " "
            )
          )
        )
    )
    (defun psm02 ( / pms09 pms10 pms11)
      (setq pms09 (getvar "CLAYER"))
      (setq pms10 0)
      (setq pms11 (strcat "_" (itoa pms10)))
        (while (tblsearch "LAYER" pms11)
          (setq pms11 (strcat "_" (itoa (setq pms10 (1+ pms10)))))
        )
      (entmake (list (cons 0 "LAYER") (cons 100 "AcDbSymbolTableRecord") (cons 100 "AcDbLayerTableRecord") (cons 2 pms11) (cons 70 0) (cons 62 -7)))
      (setvar "CLAYER" pms11)
      (list pms11 pms09)
    )
    (defun psm03 ( / pms12)
      (setq pms12 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= pms12 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq pms13 T)
            (setq pms13 nil)
        )
        (if (not pms13)
          (alert "\042acm-umfassung\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      pms13
    )
    (defun psm04 (pms03 / pms14 pms15 pms16 pms10 pms17 pms18 pms19 pms20 pms21 pms22 pms23 pms24 pms25 pms26 pms27 pms06 pms07 pms28 pms29 pms30)
      (setq pms14 (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq pms15 pms03)
      (setq pms16 (sslength pms15))
      (setq pms10 -1)
      (setq pms17 (ssadd))
        (repeat pms16
          (setq pms10 (1+ pms10))
          (setq pms18 (ssname pms15 pms10))
          (setq pms19 (vlax-ename->vla-object pms18))
          (setq pms20 (vla-Copy pms19))
          (setq pms21 (vlax-vla-object->ename pms20))
          (ssadd pms21 pms17)
        )
      (setq pms10 0)
      (setq pms22 (strcat "unl" (itoa pms10)))
        (while (tblsearch "BLOCK" pms22)
          (setq pms22 (strcat "blo" (itoa (setq pms10 (1+ pms10)))))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (vl-cmdf "._-block" pms22 (list 0.0 0.0 0.0) pms17 "")
      (vl-cmdf "._-insert" pms22 (list 0.0 0.0 0.0) 1.0 1.0 0.0)
      (setq pms25 (vlax-ename->vla-object (entlast)))
      (vla-GetBoundingBox pms25 'pms95 'pms96)
      (setq pms26 (vlax-safearray->list pms95))
      (setq pms27 (vlax-safearray->list pms96))
      (setq pms06 (list (car pms27) (cadr pms26) (caddr pms26)))
      (setq pms07 (list (car pms27) (cadr pms27) (caddr pms26)))
      (setq pms28 (distance pms26 pms06))
      (setq pms29 (distance pms06 pms07))
      (setq pms30 (distance pms07 pms27))
      (vl-catch-all-apply 'vla-Delete (list pms25))
      (vl-catch-all-apply 'vla-Delete (list (vla-Item (vla-get-Blocks (vla-get-ActiveDocument (vlax-get-acad-object))) pms22)))
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      (setvar "OSMODE" pms14)
      (list (list pms26 pms27) (list pms28 pms29 pms30))
    )
    (defun psm05 (pms01 pms02 / pms31 V-Curspace pms23 pms24 pms33 pms34 pms35 pms36 pms37 pms38 pms39 pms40 pms41 pms42 pms43 pms44 pms45 pms46 pms47 pms48 pms49 pms50 pms51 pms52 pms53 pms54 pms55)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setq pms02 (list (car pms02) (cadr pms02) (caddr pms02)))
      (setq pms01 (list (car pms01) (cadr pms01) (caddr pms01)))
      (setq pms33 (list (car pms02) (cadr pms01) (caddr pms02)))
      (setq pms34 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms35 pms34)
      (setq pms36 (list (car pms01) (cadr pms01) (caddr pms02)))
      (setq pms37 pms01)
      (setq pms38 pms37)
      (setq pms39 (list (car pms01) (cadr pms02) (caddr pms02)))
      (setq pms40 (list (car pms01) (cadr pms02) (caddr pms01)))
      (setq pms41 pms37)
      (setq pms42 pms02)
      (setq pms43 (list (car pms02) (cadr pms02) (caddr pms01)))
      (setq pms44 pms34)
      (setq pms45 pms42)
      (setq pms46 pms42)
      (setq pms47 pms33)
      (setq pms48 pms39)
      (setq pms49 pms39)
      (setq pms50 pms36)
      (setq pms51 (append pms33 pms34 pms35 pms36 pms37 pms38 pms39 pms40 pms41 pms42 pms43 pms44 pms45 pms46 pms47 pms48 pms49 pms50))
      (setq pms52 (vlax-make-safearray vlax-vbDouble (cons 0 (1- (length pms51)))))
      (setq pms53 (vlax-safearray-fill pms52 pms51))
      (setq pms54 (vlax-make-variant pms53))
      (setq pms55 (vla-Add3DMesh pms32 6 3 pms54))
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms55
    )
    (defun psm06 (pms01 pms02 / pms31 pms32 pms56 pms23 pms24 pms57 pms58)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
      (setq pms56 (psm07 pms01 pms02))
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setq pms57 (- (caddr pms02) (caddr pms01)))
      (setq pms58 (vla-AddExtrudedSolid pms32 pms56 pms57 0))
      (vl-catch-all-apply 'vla-Delete (list pms56))
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms58
    )
    (defun psm07 (pms01 pms02 / pms31 pms32 pms23 pms24 pms59 pms60 pms61 pms62 pms63 pms64 pms65)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setq pms59 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms60 (list (car pms01) (cadr pms02) (caddr pms01)))
      (setq pms02 (list (car pms02) (cadr pms02) (caddr pms01)))
      (setq pms61 (append pms01 pms59 pms02 pms60 pms01))
      (setq pms62 (vlax-make-safearray vlax-vbdouble (cons 0 14)))
      (vlax-safearray-fill pms62 pms61)
      (setq pms63 (vla-Add3DPoly pms32 pms62))
      (setq pms64 (vlax-make-safearray vlax-vbObject '(0 . 0)))
      (vlax-safearray-put-element pms64 0 pms63)
      (setq pms65 (vla-AddRegion pms32 pms64))
      (setq pms65 (car (vlax-safearray->list (vlax-variant-value pms65))))
      (vl-catch-all-apply 'vla-Delete (list pms63))
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms65
    )
    (defun psm08 (pms04 / pms66 pms67 pms13)
        (if (setq pms66 (psm09))
          (progn
            (setq pms67 (load_dialog pms66))
              (if (not (new_dialog "huelle" pms67))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list pms66))
              (if (not (vl-position kwlbhwotmru9mkerdpep (list "0" "1")))
                (setq kwlbhwotmru9mkerdpep "0")
              )
              (if (not (vl-position kwlbhwotmru8mkerdpep (list "0" "1" "2" "3" "4" "5")))
                (setq kwlbhwotmru8mkerdpep "0")
              )
              (if (not (vl-position kwlbhwotmru7mkerdpep (list "0" "1")))
                (setq kwlbhwotmru7mkerdpep "0")
              )
            (start_list "pl_01")
            (mapcar 'add_list (list "Linienzug" "Polylinie" "2D-Polylinie" "3D-Polylnie" "Region" "Abdeckungsobjekt"))
            (end_list)
            (start_list "pl_02")
            (mapcar 'add_list (list "Polygonnetz" "3D-Volumenkrper"))
            (end_list)
              (if (= kwlbhwotmru9mkerdpep "0")
                (progn
                  (set_tile "rb_01" "1")
                  (mode_tile "pl_01" 2)
                  (mode_tile "pl_02" 1)
                )
              )
              (if (= kwlbhwotmru9mkerdpep "1")
                (progn
                  (set_tile "rb_02" "1")
                  (mode_tile "pl_02" 2)
                  (mode_tile "pl_01" 1)
                )
              )
            (set_tile "pl_01" kwlbhwotmru8mkerdpep)
            (set_tile "pl_02" kwlbhwotmru7mkerdpep)
              (if (= pms04 0)
                (progn
                  (set_tile "rb_01" "1")
                  (set_tile "rb_02" "0")
                  (mode_tile "rb_02" 1)
                  (mode_tile "pl_02" 1)
                )
              )
              (action_tile "rb_01" "(set_tile \"rb_02\" \"0\")
                (mode_tile \"pl_01\" 0)
                (mode_tile \"pl_01\" 2)
                (mode_tile \"pl_02\" 1)"
              )
              (action_tile "rb_02" "(set_tile \"rb_01\" \"0\")
                (mode_tile \"pl_02\" 0)
                (mode_tile \"pl_02\" 2)
                (mode_tile \"pl_01\" 1)"
              )
              (action_tile "b_01" "(setq pms13
                (list
                  (setq kwlbhwotmru9mkerdpep (get_tile \"rb_02\"))
                  (setq kwlbhwotmru8mkerdpep (get_tile \"pl_01\"))
                  (setq kwlbhwotmru7mkerdpep (get_tile \"pl_02\"))
                ))
                 (done_dialog)"
              )
              (action_tile "b_02" "(setq pms13 nil)
                (done_dialog)"
              )
            (start_dialog)
            (unload_dialog pms67)
          )
        )
      pms13
    )
    (defun psm09 ( / pms71 pms72 pms73 pms74)
      (if
        (and
          (setq pms71 (vl-filename-mktemp "acm.dcl"))
          (setq pms72 (open pms71 "w"))
        )
          (progn
              (if (= (getvar "PLINETYPE") 0)
                (setq pms73 (list "Linienzug" "2D-Polylinie"))
                (setq pms73 (list "Linienzug" "Polylinie"))
              )
            (setq pms74
              (list
                "huelle"
                ":dialog{label=\042Optionen\042;"
                ":spacer{height=0;}"
                ":radio_button{key=\042rb_01\042;label=\042&2D-Umfassung\042;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=37;"
                ":popup_list{key=\042pl_01\042;label=\042&Erstellen als:\042;}}}"
                ":spacer{height=0.5;}"
                ":radio_button{key=\042rb_02\042;label=\042&3D-Umfassung\042;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=37;"
                ":popup_list{key=\042pl_02\042;label=\042Erstellen &als:\042;}}}"
                ":spacer{height=1;}"
                ":row{"
                ":spacer{width=5;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=5;}}}"
              )
            )
              (while pms74
                (write-line (car pms74) pms72)
                (setq pms74 (cdr pms74))
              )
            (setq pms72 (close pms72))
            pms71
          )
          nil
      )
    )
    (defun psm10 (pms01 pms02 / pms31 pms32 pms23 pms24 pms59 pms60 pms61 pms62 pms63)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setq pms59 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms60 (list (car pms01) (cadr pms02) (caddr pms01)))
      (setq pms02 (list (car pms02) (cadr pms02) (caddr pms01)))
      (setq pms61 (append pms01 pms59 pms02 pms60))
      (setq pms62 (vlax-make-safearray vlax-vbdouble (cons 0 11)))
      (vlax-safearray-fill pms62 pms61)
      (setq pms63 (vla-Add3DPoly pms32 pms62))
      (vlax-put pms63 'Closed 1)
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms63
    )
    (defun psm11 (pms01 pms02 / pms75 pms31 pms32 pms23 pms24 pms59 pms60 pms61 pms62 pms63)
      (setq pms75 (getvar "ELEVATION"))
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setvar "ELEVATION" (caddr pms01))
      (setq pms59 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms60 (list (car pms01) (cadr pms02) (caddr pms01)))
      (setq pms02 (list (car pms02) (cadr pms02) (caddr pms01)))
      (setq pms61 (append pms01 pms59 pms02 pms60))
      (setq pms62 (vlax-make-safearray vlax-vbdouble (cons 0 11)))
      (vlax-safearray-fill pms62 pms61)
      (setq pms63 (vla-AddPolyline pms32 pms62))
      (vlax-put pms63 'Closed 1)
      (setvar "ELEVATION" pms75)
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms63
    )
    (defun psm12 (pms01 pms02 / pms75 pms31 pms32 pms23 pms24 pms59 pms60)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setq pms59 (list (car pms02) (cadr pms01) (caddr pms01)))
      (setq pms60 (list (car pms01) (cadr pms02) (caddr pms01)))
      (setq pms02 (list (car pms02) (cadr pms02) (caddr pms01)))
      (vla-AddLine pms32 (vlax-3D-point pms01) (vlax-3D-point pms59))
      (vla-AddLine pms32 (vlax-3D-point pms59) (vlax-3D-point pms02))
      (vla-AddLine pms32 (vlax-3D-point pms02) (vlax-3D-point pms60))
      (vla-AddLine pms32 (vlax-3D-point pms60) (vlax-3D-point pms01))
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
    )
    (defun psm13 (pms01 pms02 / pms75 pms31 pms32 pms05 pms06 pms07 pms08 pms76 pms77 pms78 pms62 pms23 pms24 pms63)
      (setq pms75 (getvar "ELEVATION"))
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace pms31) :vlax-true)
              (setq pms32 (vla-get-ModelSpace pms31))
              (setq pms32 (vla-get-PaperSpace pms31))
            )
          )
          (setq pms32 (vla-get-ModelSpace pms31))
        )
      (setq pms05 (list (car pms01) (cadr pms01)))
      (setq pms06 (list (car pms02) (cadr pms01)))
      (setq pms07 (list (car pms02) (cadr pms02)))
      (setq pms08 (list (car pms01) (cadr pms02)))
      (setq pms76 (list pms05 pms06 pms07 pms08))
        (while pms76
          (setq pms77 (car pms76))
          (setq pms78 (append pms78 (list (car pms77) (cadr pms77))))
          (setq pms76 (cdr pms76))
        )
      (setq pms62 (vlax-make-safearray vlax-vbdouble (cons 0 (1- (length pms78)))))
      (vlax-safearray-fill pms62 pms78)
        (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
          (progn
            (setq pms24 1)
            (vla-put-Lock pms23 :vlax-false)
          )
        )
      (setvar "ELEVATION" (caddr pms01))
      (setq pms63 (vla-AddLightWeightPolyline pms32 pms62))
      (vlax-put pms63 'Closed 1)
      (setvar "ELEVATION" pms75)
        (if (= pms24 1)
          (vla-put-Lock pms23 :vlax-true)
        )
      pms63
    )
    (defun psm14 (pms01 pms02 / pms14 pms30 pms05 pms06 pms07 pms08 pms79 pms80)
      (setq pms14 (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq pms30 0.0)
      (setq pms05 (list (car pms01) (cadr pms01) pms30))
      (setq pms06 (list (car pms02) (cadr pms01) pms30))
      (setq pms07 (list (car pms02) (cadr pms02) pms30))
      (setq pms08 (list (car pms01) (cadr pms02) pms30))
      (vl-cmdf "._wipeout" pms05 pms06 pms07 pms08 "_c")
      (setq pms79 (vlax-ename->vla-object (entlast)))
      (setq pms80 (caddr pms02))
      (vla-Move pms79 (vlax-3D-point (list 0.0 0.0 0.0)) (vlax-3D-point (list 0.0 0.0 pms80)))
      (setvar "OSMODE" pms14)
    )
    (defun psm15 ( / pms81 pms82 pms23 pms24 pms83 pms84 pms85 pms86 pms26 pms27 pms87 pms88 pms89 pms90 pms91 pms92)
      (prompt "\nZu umfassende Objekte whlen ... ")
      (if (setq pms81 (ssget "_:L"))
        (progn
            (if (/= (getvar "WORLDUCS") 1)
              (progn
                (vl-cmdf "._ucs" "_w")
                (setq pms82 1)
              )
            )
            (if (= (vla-get-Lock (setq pms23 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
              (progn
                (setq pms24 1)
                (vla-put-Lock pms23 :vlax-false)
              )
            )
          (setq pms83 (psm02))
          (setq pms84 (car pms83))
          (setq pms85 (psm04 pms81))
          (setvar "CLAYER" (cadr pms83))
            (if (setq pms86 (ssget "_x" (list (cons 8 pms84) (cons 410 (getvar "CTAB")))))
              (vl-cmdf "._erase" pms86 "")
            )
          (vl-catch-all-apply 'vla-Delete (list (vlax-ename->vla-object (tblobjname "LAYER" pms84))))
          (setq pms26 (car (car pms85)))
          (setq pms27 (cadr (car pms85)))
          (setq pms87 (cadr pms85))
          (setq pms88 (caddr pms26))
          (setq pms89 (caddr pms27))
            (if (equal pms88 pms89 0.0001)
              (progn
                (setq kwlbhwotmru9mkerdpep "0")
                (setq pms90 0)
                  (if
                    (and
                      (> (car pms87) 0.0)
                      (> (cadr pms87) 0.0)
                    )
                      (setq pms91 1)
                      (progn
                        (setq pms91 0)
                        (prompt "\nKann keine Umfassung erstellen. ")
                      )
                  )
              )
              (progn
                (setq pms90 1)
                  (if
                    (and
                      (> (car pms87) 0.0)
                      (> (cadr pms87) 0.0)
                      (> (caddr pms87) 0.0)
                    )
                      (setq pms91 1)
                      (progn
                        (setq pms91 0)
                        (prompt "\nKann keine Umfassung erstellen. ")
                      )
                  )
              )
            )
            (if
              (and
                (= pms91 1)
                (setq pms92 (psm08 pms90))
              )
                (progn
                    (if (= kwlbhwotmru9mkerdpep "0")
                      (progn
                        (if (= kwlbhwotmru8mkerdpep "0")
                          (psm12 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru8mkerdpep "1")
                          (psm13 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru8mkerdpep "2")
                          (psm11 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru8mkerdpep "3")
                          (psm10 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru8mkerdpep "4")
                          (psm07 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru8mkerdpep "5")
                          (psm14 (car (car pms85)) (cadr (car pms85)))
                        )
                      )
                      (progn
                        (if (= kwlbhwotmru7mkerdpep "0")
                          (psm05 (car (car pms85)) (cadr (car pms85)))
                        )
                        (if (= kwlbhwotmru7mkerdpep "1")
                          (psm06 (car (car pms85)) (cadr (car pms85)))
                        )
                      )
                    )
                  (psm01 pms26 pms27)
                )
            )
          (if (= pms82 1)
            (vl-cmdf "._ucs" "_p")
          )
          (if (= pms24 1)
            (vla-put-Lock pms23 :vlax-true)
          )
        )
      )
    )
  (if (psm03)
    (progn
      (vl-load-com)
      (setq pms93 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq pms31 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq pms94 *error*)
      (setq *error* acmDBE_ErrorHandler)
      (vla-EndUndoMark pms31)
      (vla-StartUndoMark pms31)
      (psm15)
        (if pms94
          (setq *error* pms94)
          (setq *error* nil)
        )
      (setvar "CMDECHO" pms93)
      (vla-EndUndoMark pms31)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-UMFASSUNG (Copyright  2024 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-UMFASSUNG auf.")
